#ifndef __ASI_MASTER_ERROR_H
#define __ASI_MASTER_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// AS-Interface Master
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_ASI_MASTER_PARAM_CYCLETIME
//
// MessageText:
//
//  Invalid value for parameter cycletime.
//
#define TLR_E_ASI_MASTER_PARAM_CYCLETIME ((TLR_RESULT)0xC07A0001L)

//
// MessageId: TLR_E_ASI_MASTER_PARAM_XC_INSTANCE
//
// MessageText:
//
//  Invalid value for parameter xC instance.
//
#define TLR_E_ASI_MASTER_PARAM_XC_INSTANCE ((TLR_RESULT)0xC07A0002L)

//
// MessageId: TLR_E_ASI_MASTER_PARAM_QUEUE_ELEMENT
//
// MessageText:
//
//  Invalid value for parameter queue element.
//
#define TLR_E_ASI_MASTER_PARAM_QUEUE_ELEMENT ((TLR_RESULT)0xC07A0003L)

//
// MessageId: TLR_E_ASI_MASTER_PARAM_POOL_ELEMENT
//
// MessageText:
//
//  Invalid value for parameter pool element.
//
#define TLR_E_ASI_MASTER_PARAM_POOL_ELEMENT ((TLR_RESULT)0xC07A0004L)

//
// MessageId: TLR_E_ASI_MASTER_PARAM_MIN_CYCLE_TIME
//
// MessageText:
//
//  Invalid value for parameter min cycle timer.
//
#define TLR_E_ASI_MASTER_PARAM_MIN_CYCLE_TIME ((TLR_RESULT)0xC07A0005L)

//
// MessageId: TLR_E_ASI_MASTER_PARAM_OPERATION_MODE
//
// MessageText:
//
//  Invalid value for parameter operation mode.
//
#define TLR_E_ASI_MASTER_PARAM_OPERATION_MODE ((TLR_RESULT)0xC07A0006L)

//
// MessageId: TLR_E_ASI_MASTER_PARAM_DATA_EXCHANGE
//
// MessageText:
//
//  Invalid value for parameter data exchange.
//
#define TLR_E_ASI_MASTER_PARAM_DATA_EXCHANGE ((TLR_RESULT)0xC07A0007L)

//
// MessageId: TLR_E_ASI_MASTER_PARAM_AUTO_ADDRESS_ENABLE
//
// MessageText:
//
//  Invalid value for parameter auto address enable.
//
#define TLR_E_ASI_MASTER_PARAM_AUTO_ADDRESS_ENABLE ((TLR_RESULT)0xC07A0008L)

//
// MessageId: TLR_E_ASI_MASTER_PARAM_MANAGEMENT_PHASE
//
// MessageText:
//
//  Invalid value for parameter management phase.
//
#define TLR_E_ASI_MASTER_PARAM_MANAGEMENT_PHASE ((TLR_RESULT)0xC07A0009L)

//
// MessageId: TLR_E_ASI_MASTER_PARAM_PROCESS_DATA_MODE
//
// MessageText:
//
//  Invalid value for parameter process data mode.
//
#define TLR_E_ASI_MASTER_PARAM_PROCESS_DATA_MODE ((TLR_RESULT)0xC07A000AL)

//
// MessageId: TLR_E_ASI_MASTER_PARAM_DATA_FORMAT
//
// MessageText:
//
//  Invalid value for parameter process data format.
//
#define TLR_E_ASI_MASTER_PARAM_DATA_FORMAT ((TLR_RESULT)0xC07A000BL)

//
// MessageId: TLR_E_ASI_MASTER_INIT_BUFFER
//
// MessageText:
//
//  Failed to initialize data buffer.
//
#define TLR_E_ASI_MASTER_INIT_BUFFER     ((TLR_RESULT)0xC07A000CL)

//
// MessageId: TLR_E_ASI_MASTER_INITIALIZING
//
// MessageText:
//
//  Master is initializing.
//
#define TLR_E_ASI_MASTER_INITIALIZING    ((TLR_RESULT)0xC07A000DL)

//
// MessageId: TLR_E_ASI_MASTER_DATA_COUNT
//
// MessageText:
//
//  Invalid data count.
//
#define TLR_E_ASI_MASTER_DATA_COUNT      ((TLR_RESULT)0xC07A000EL)

//
// MessageId: TLR_E_ASI_MASTER_DATA_OFFSET
//
// MessageText:
//
//  Invalid data offset.
//
#define TLR_E_ASI_MASTER_DATA_OFFSET     ((TLR_RESULT)0xC07A000FL)

//
// MessageId: TLR_E_ASI_MASTER_NOT_ALLOWED_IN_PROTECTED_MODE
//
// MessageText:
//
//  Request is not allowed in protected mode.
//
#define TLR_E_ASI_MASTER_NOT_ALLOWED_IN_PROTECTED_MODE ((TLR_RESULT)0xC07A0010L)

//
// MessageId: TLR_E_ASI_MASTER_AUTO_CLEAR
//
// MessageText:
//
//  Master is in auto-clear state.
//
#define TLR_E_ASI_MASTER_AUTO_CLEAR      ((TLR_RESULT)0xC07A0011L)

//
// MessageId: TLR_E_ASI_MASTER_CONTROL_ERROR
//
// MessageText:
//
//  Control error detected.
//
#define TLR_E_ASI_MASTER_CONTROL_ERROR   ((TLR_RESULT)0xC07A0012L)

//
// MessageId: TLR_E_ASI_MASTER_SLAVE_MISSING
//
// MessageText:
//
//  Slave is missing.
//
#define TLR_E_ASI_MASTER_SLAVE_MISSING   ((TLR_RESULT)0xC07A0013L)

//
// MessageId: TLR_E_ASI_MASTER_POWER_FAILURE
//
// MessageText:
//
//  Power failure detected.
//
#define TLR_E_ASI_MASTER_POWER_FAILURE   ((TLR_RESULT)0xC07A0014L)

//
// MessageId: TLR_E_ASI_MASTER_OFFLINE_READY
//
// MessageText:
//
//  Master is in offline ready state.
//
#define TLR_E_ASI_MASTER_OFFLINE_READY   ((TLR_RESULT)0xC07A0015L)

//
// MessageId: TLR_E_ASI_MASTER_NOT_IN_NORMAL_OPERATION
//
// MessageText:
//
//  Master is not in normal operation.
//
#define TLR_E_ASI_MASTER_NOT_IN_NORMAL_OPERATION ((TLR_RESULT)0xC07A0016L)

//
// MessageId: TLR_E_ASI_MASTER_INVALID_SLAVE_ADDRESS
//
// MessageText:
//
//  Invalid slave address.
//
#define TLR_E_ASI_MASTER_INVALID_SLAVE_ADDRESS ((TLR_RESULT)0xC07A0017L)

//
// MessageId: TLR_E_ASI_MASTER_SLAVE_ACTIVATED
//
// MessageText:
//
//  Slave is activated.
//
#define TLR_E_ASI_MASTER_SLAVE_ACTIVATED ((TLR_RESULT)0xC07A0018L)

//
// MessageId: TLR_E_ASI_MASTER_SLAVE_NOT_ACTIVATED
//
// MessageText:
//
//  Slave is not activated.
//
#define TLR_E_ASI_MASTER_SLAVE_NOT_ACTIVATED ((TLR_RESULT)0xC07A0019L)

//
// MessageId: TLR_E_ASI_MASTER_SLAVE_DETECTED
//
// MessageText:
//
//  Slave is detected.
//
#define TLR_E_ASI_MASTER_SLAVE_DETECTED  ((TLR_RESULT)0xC07A001AL)

//
// MessageId: TLR_E_ASI_MASTER_SLAVE_NOT_DETECTED
//
// MessageText:
//
//  Slave is not detected.
//
#define TLR_E_ASI_MASTER_SLAVE_NOT_DETECTED ((TLR_RESULT)0xC07A001BL)

//
// MessageId: TLR_E_ASI_MASTER_TIMEOUT
//
// MessageText:
//
//  Timeout detected.
//
#define TLR_E_ASI_MASTER_TIMEOUT         ((TLR_RESULT)0xC07A001CL)

//
// MessageId: TLR_E_ASI_MASTER_SLAVE_0_DETECTED
//
// MessageText:
//
//  Slave at address 0 detected.
//
#define TLR_E_ASI_MASTER_SLAVE_0_DETECTED ((TLR_RESULT)0xC07A001DL)

//
// MessageId: TLR_E_ASI_MASTER_NEW_SLAVE_DETECTED
//
// MessageText:
//
//  Slave at new address detected.
//
#define TLR_E_ASI_MASTER_NEW_SLAVE_DETECTED ((TLR_RESULT)0xC07A001EL)

//
// MessageId: TLR_E_ASI_MASTER_DELETE_ADDRESS
//
// MessageText:
//
//  Error with deletion of address.
//
#define TLR_E_ASI_MASTER_DELETE_ADDRESS  ((TLR_RESULT)0xC07A001FL)

//
// MessageId: TLR_E_ASI_MASTER_READ_EXT_ID1
//
// MessageText:
//
//  Error with reading extended ID code 1.
//
#define TLR_E_ASI_MASTER_READ_EXT_ID1    ((TLR_RESULT)0xC07A0020L)

//
// MessageId: TLR_E_ASI_MASTER_SET_EXT_ID1
//
// MessageText:
//
//  Error with setting extended ID code 1.
//
#define TLR_E_ASI_MASTER_SET_EXT_ID1     ((TLR_RESULT)0xC07A0021L)

//
// MessageId: TLR_E_ASI_MASTER_ADDRESS_SET_TEMPORARY
//
// MessageText:
//
//  New address stored temporarily.
//
#define TLR_E_ASI_MASTER_ADDRESS_SET_TEMPORARY ((TLR_RESULT)0xC07A0022L)

//
// MessageId: TLR_E_ASI_MASTER_SET_ADDRESS
//
// MessageText:
//
//  Error with setting new address.
//
#define TLR_E_ASI_MASTER_SET_ADDRESS     ((TLR_RESULT)0xC07A0023L)

//
// MessageId: TLR_E_ASI_MASTER_EXT_ID1_SET_TEMPORARY
//
// MessageText:
//
//  Extended ID code 1 stored temporarily.
//
#define TLR_E_ASI_MASTER_EXT_ID1_SET_TEMPORARY ((TLR_RESULT)0xC07A0024L)

//
// MessageId: TLR_E_ASI_MASTER_INVALID_SLAVE_PROFILE
//
// MessageText:
//
//  Invalid slave profile.
//
#define TLR_E_ASI_MASTER_INVALID_SLAVE_PROFILE ((TLR_RESULT)0xC07A0025L)

//
// MessageId: TLR_E_ASI_MASTER_SLAVE_CONFIG
//
// MessageText:
//
//  Invalid slave configuration.
//
#define TLR_E_ASI_MASTER_SLAVE_CONFIG    ((TLR_RESULT)0xC07A0026L)

//
// MessageId: TLR_E_ASI_MASTER_SLAVE_ALREADY_CONFIGURED
//
// MessageText:
//
//  Slave is alrady configured.
//
#define TLR_E_ASI_MASTER_SLAVE_ALREADY_CONFIGURED ((TLR_RESULT)0xC07A0027L)

//
// MessageId: TLR_E_ASI_MASTER_STRING_TRANSFER_DATA_OVERFLOW
//
// MessageText:
//
//  Data overflow during stringtansfer detected.
//
#define TLR_E_ASI_MASTER_STRING_TRANSFER_DATA_OVERFLOW ((TLR_RESULT)0xC07A0028L)

//
// MessageId: TLR_E_ASI_MASTER_PARAM_AUTOCLEAR_WITH_AUTOADRESS
//
// MessageText:
//
//  Invalid value for parameter autoclear in combiantion with value for parameter autoaddress.
//
#define TLR_E_ASI_MASTER_PARAM_AUTOCLEAR_WITH_AUTOADRESS ((TLR_RESULT)0xC07A0029L)

//
// MessageId: TLR_E_ASI_MASTER_PARAM_AUTOCLEAR_WITH_CONFIG_MODE
//
// MessageText:
//
//  Invalid value for parameter autoclear in combiantion with value for parameter operationmode.
//
#define TLR_E_ASI_MASTER_PARAM_AUTOCLEAR_WITH_CONFIG_MODE ((TLR_RESULT)0xC07A002AL)

//
// MessageId: TLR_E_ASI_MASTER_COMMAND_NOT_ALLOWD_WITH_AUTOCLEAR
//
// MessageText:
//
//  Commad is not allowed if autoclear is active.
//
#define TLR_E_ASI_MASTER_COMMAND_NOT_ALLOWD_WITH_AUTOCLEAR ((TLR_RESULT)0xC07A002BL)

//
// MessageId: TLR_E_ASI_MASTER_NOT_ALLOWED_IN_TRANSPARENT_MODE
//
// MessageText:
//
//  Request is not allowed in transparent mode.
//
#define TLR_E_ASI_MASTER_NOT_ALLOWED_IN_TRANSPARENT_MODE ((TLR_RESULT)0xC07A002CL)

//
// MessageId: TLR_E_ASI_MASTER_ONLY_ALLOWED_IN_TRANSPARENT_MODE
//
// MessageText:
//
//  Request is only allowed in transparent mode.
//
#define TLR_E_ASI_MASTER_ONLY_ALLOWED_IN_TRANSPARENT_MODE ((TLR_RESULT)0xC07A002DL)




#endif  //__ASI_MASTER_ERROR_H

